using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;

using System.Windows.Forms;


namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class DlgSpecimenSearch
	/// </summary>
	public class DlgSpecimenSearch : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		#region Variables

		private BOL.Patient _patient;

		#endregion

		#region Form Controls

		private System.Windows.Forms.Button btnCancel;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private gov.va.med.vbecs.GUI.controls.PatientSpecimenSelector patientSpecimenSelector1;
		private System.ComponentModel.IContainer components = null;

		#endregion

		#region Constructors/Dispose

		/// <summary>
		/// DlgSpecimenSearch
		/// </summary>
		public DlgSpecimenSearch()
		{
			InitializeComponent();

			SetComponentProperties();
		}

		/// <summary>
		/// Constructor
		/// </summary>
		public DlgSpecimenSearch(BOL.Patient patient) : this()
		{
			this.patientSpecimenSelector1.Patient = patient;
			this._patient = patient;
		}

		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="patient"></param>
		/// <param name="specimenUid"></param>
		public DlgSpecimenSearch(BOL.Patient patient, string specimenUid) : this(patient)
		{
			this.patientSpecimenSelector1.SearchSpecimenUid = specimenUid;
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}
		#endregion

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.btnCancel = new System.Windows.Forms.Button();
			this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.patientSpecimenSelector1 = new gov.va.med.vbecs.GUI.controls.PatientSpecimenSelector();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(712, 30);
			this.vbecsLogo1.TabIndex = 3;
			this.vbecsLogo1.Title = "Select Patient Specimen";
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 449);
			this.lblRequiredField.Name = "lblRequiredField";
			this.lblRequiredField.TabIndex = 4;
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Location = new System.Drawing.Point(632, 440);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 2;
			this.btnCancel.Text = "&Cancel";
			// 
			// btnOK
			// 
			this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOK.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.btnOK.EnabledButton = false;
			this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnOK.Image = null;
			this.btnOK.Location = new System.Drawing.Point(552, 440);
			this.btnOK.Name = "btnOK";
			this.btnOK.Size = new System.Drawing.Size(75, 23);
			this.btnOK.TabIndex = 1;
			// 
			// patientSpecimenSelector1
			// 
			this.patientSpecimenSelector1.AcceptableOnlySpecimen = true;
			this.patientSpecimenSelector1.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.patientSpecimenSelector1.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(178)));
			this.patientSpecimenSelector1.Location = new System.Drawing.Point(4, 32);
			this.patientSpecimenSelector1.Name = "patientSpecimenSelector1";
			this.patientSpecimenSelector1.Patient = null;
			this.patientSpecimenSelector1.Size = new System.Drawing.Size(704, 404);
			this.patientSpecimenSelector1.Specimen = null;
			this.patientSpecimenSelector1.TabIndex = 0;
			// 
			// DlgSpecimenSearch
			// 
			this.AcceptButton = this.btnOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(712, 465);
			this.Controls.Add(this.patientSpecimenSelector1);
			this.Controls.Add(this.btnOK);
			this.Controls.Add(this.btnCancel);
			this.hlphelpChm.SetHelpKeyword(this, "Maintain_Specimen.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MinimumSize = new System.Drawing.Size(664, 492);
			this.Name = "DlgSpecimenSearch";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS - Select Patient Specimen";
			this.KeyDownSpeakMessage += new gov.va.med.vbecs.GUI.VbecsBaseForm.KeyDownSpeakMessageEventHandler(this.DlgSpecimenSearch_KeyDownSpeakMessage);
			this.Controls.SetChildIndex(this.btnCancel, 0);
			this.Controls.SetChildIndex(this.btnOK, 0);
			this.Controls.SetChildIndex(this.patientSpecimenSelector1, 0);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.ResumeLayout(false);

		}
		#endregion

		#region Methods


		/// <summary>
		/// Private method to initialize UI control properties
		/// </summary>
		private void SetComponentProperties()
		{
			this.vbecsLogo1.Title = "Select Patient Specimen";
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			//
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC035.DlgSpecimenSearch());
			//
			this.btnOK.Text = "&OK";
			this.btnOK.EnabledButton = false;

			this.lblRequiredField.Visible = false;
			
			this.patientSpecimenSelector1.ItemSelected += new EventHandler(this.CheckValid);
			this.patientSpecimenSelector1.ItemDeselected += new EventHandler(this.CheckValid);

		}

		/// <summary>
		/// CheckValid
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void CheckValid(object sender, System.EventArgs e)
		{
			btnOK.EnabledButton = (bool) sender;
		}

		#endregion

		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void DlgSpecimenSearch_KeyDownSpeakMessage(object sender, System.EventArgs e)
		{
			this.patientSpecimenSelector1.Speak(sender, e);
		}


		#region Properties

		/// <summary>
		/// Specimen UID
		/// </summary>
		public string SpecimenUid
		{
			get
			{
				return this.patientSpecimenSelector1.PatientSpecimenUid;
			}
		}

		#endregion

		


	}
}

